var Columns_navigation01 = function() {
	/* private私有作用域 */
	var opts = {
			showset : '',
			columnScroll:'',
			othercolumnsScroll:'',
			listRefresh:'',
			ulwidth:0
	}
	var init = function(options) {// 初始化方法, options初始化参数
		$.extend(opts, options);// 扩展参数,没有传递的参数会使用默认值
		
		var currentColumn = sessionStorage["currentColumn"];	
		$("#singleScrollUl .active").removeClass('current');
		if(currentColumn != null){
			$("[data-id="+currentColumn+"]").addClass('current');
		}
		
		if(opts.showset=='single-line'){		
			setColumnWidth();
			
			opts.columnScroll=new iScroll("singleScroll",{
					zoom: false,
					hScrollbar: false,
					vScrollbar : false,
					bounce: false,
					snap:"li",
					momentum:false,
					vScroll:false,
					onScrollEnd:disableArrow
				});		
			if(currentColumn != null){
				var x = parseFloat(sessionStorage["columnx"]);
				opts.columnScroll.scrollTo(x,0,100);				
			}
		}
		if(opts.showset=='multi-line-hid'){		
			setColumnHeight();
			opts.columnScroll=new iScroll("singleScrollDiv",{
					zoom: false,
					hScrollbar: false,
					vScrollbar : false,
					bounce: false,					
					momentum:false,
				    onBeforeScrollStart: function(e) {
						var target = e.target;
						opts.columnScroll.targetElement = target;
						opts.columnScroll.clickFunc = $(target).attr("onclick");
						
						while (target.nodeType != 1) target = target.parentNode;
						if (target.tagName != 'SELECT' && target.tagName != 'INPUT' && target.tagName != 'TEXTAREA' && target.tagName != 'BUTTON'){
							if(!$.os.ios){
								e.preventDefault();
							}
						}
					},
					onScrollMove :function(event){
						event.preventDefault();
						event.stopPropagation();
						opts.columnScroll.touchMoveFlag = true;
					},
					onTouchEnd : function(){
						if(opts.columnScroll.touchMoveFlag){
							$(opts.columnScroll.targetElement).removeAttr("onclick");
							setTimeout(function(){
								$(opts.columnScroll.targetElement).attr("onclick",opts.columnScroll.clickFunc);
								opts.columnScroll.targetElement = null;
								opts.columnScroll.clickFunc = null;
								opts.columnScroll.startY = null;
								opts.columnScroll.endY = null;
								opts.columnScroll.touchMoveFlag = false;
							},50);
						}
					}			
				});	
				
				$("#singleScroll").on("touchmove",function(event){
					event.preventDefault();
					event.stopPropagation();
				});
				
				$(".more.active").click(function(){
					if(opts.columnScroll){
						setTimeout(function(){
							opts.columnScroll.refresh();
						},10);
					}
				});						
		}		
		
		var windowH = $(window).height(),
			headerH = $("#box_header").height() + ($.os.ios ? (-68) : 0),
			footerH = $("#box_footerBody").height();		
		
		$("#othercolumns").css("height",windowH-headerH-footerH +"px").bind("touchmove",function(event){
			event.preventDefault();
			event.stopPropagation();
		});
		
		$(document).tap(function(){
			$('#othercolumns').hide();
			$("#dropDownButton").removeClass("current");
		});
		$("#othercolumns").tap(function(e){
			e.stopPropagation();			
		});
		$("#dropDownButton").tap(function(e){
			e.stopPropagation();
			showSelect();
		});
		
		$(window).on("resize",function(){
			setTimeout(function(){
				var windowH = $(window).height(),
					headerH = $("#box_header").height() + ($.os.ios ? (-68) : 0),
					footerH = $("#box_footerBody").height();		
		
				$("#othercolumns").css("height",windowH-headerH-footerH +"px");
			
				if(opts.othercolumnsScroll) {
					opts.othercolumnsScroll.refresh();
				}		
				
				if(opts.columnScroll){
					setColumnHeight();
					opts.columnScroll.refresh();
				}
			
				if(opts.listRefresh){
					opts.listRefresh();
				}				
				if(myScroll){
					myScroll.refresh();
				}				
			},100);
		});
		
		
		var wholeWidth = parseFloat($("#singleScroll").width());
			
		for(var i = 0,l = $("#singleScroll li").length; i < l; i++){				
			wholeWidth -= parseFloat($("#singleScroll li").eq(i).width());				
			if( wholeWidth < 0 ){
				$("#dropDownButton").removeClass("disTap");
				break;
			}	
		}
		
		if(opts.showset=='multi-line'){		

			var windowWidth = $("#singleScroll").width();
			
			for(var i = 0,l = $("#singleScroll li").length; i < l; i++){				
				var everyWidth = $("#singleScroll li").eq(i).width();
				if(everyWidth/windowWidth<=0.25){
					$("#singleScroll li").eq(i).width("25%");
				}else if(0.5>=everyWidth/windowWidth>0.25){
					$("#singleScroll li").eq(i).width("50%");		
				}else if(0.75>=everyWidth/windowWidth>0.5){
					$("#singleScroll li").eq(i).width("75%");	
				}else if(everyWidth/windowWidth>0.75){
					$("#singleScroll li").eq(i).width("100%");	
				}
			}
		}
		
		for(var j = l - 1; j >= i ; j--) {
			$("#singleScroll li").eq(j).prependTo($("#othercolumns ul"));
		}
		
		$('.js_columngoto').click(function(){			
			var url=$(this).data('url');
			var id=$(this).data('id');
			setCurrentColumn(id);
			if(/zmobile/.test(navigator.userAgent)){
				if(context.loadUrl(url)){
					
				}else{
					window.location.href=url;
				}
			}else{
				var s=url.substr(0,4);
				if(s=='http'){
					window.open(url,'_blank');        
				}else{
					window.location.href=url;
				}				
			}
		});
		$('#columnnext').click(function(){	
			opts.columnScroll.scrollToPage('next', 0);return false;
		});
		$('#columnprev').click(function(){	
			opts.columnScroll.scrollToPage('prev', 0);return false;
		});		
	}
	var setColumnHeight = function() {	
		var windowH = $(window).height(),
			headerH = $(".z3g-headerSmall").height() + ($.os.ios ? (-68) : 0),
			footerH = $("#box_footerBody").height();
		
		$("#singleScrollDiv").css("max-height",windowH-headerH-footerH +"px");
	};
	
	var disableArrow=function(){
		var x=opts.columnScroll.x;
		var w=opts.ulwidth+x;
		var wholeWidth = parseFloat($("#singleScroll").width());
		if(w==wholeWidth){
			$('#columnnext').addClass('disTap');
			$('#columnnext').removeClass('active');			
		}else{
			$('#columnnext').removeClass('disTap');
			$('#columnnext').addClass('active');			
		}
		if(w==opts.ulwidth){
			$('#columnprev').addClass('disTap');
			$('#columnprev').removeClass('active');			
		}else{
			$('#columnprev').removeClass('disTap');
			$('#columnprev').addClass('active');			
		}				
	};
	
	var showSelect=function (){
		if($("#othercolumns").css("display")=="block"){
			$('#othercolumns').hide();	
			$("#dropDownButton").removeClass("current");		
		}else{
			$('#othercolumns').show();
			$("#dropDownButton").addClass("current");	
			if(!opts.othercolumnsScroll){
				opts.othercolumnsScroll = new iScroll("othercolumns",{
					  zoom: false,
					  hScroll: false,
					  hScrollbar: false,
					  vScrollbar : false,
					  bounce: false,
					  onBeforeScrollStart: function(e) {
						  var target = e.target;
						  opts.othercolumnsScroll.targetElement = target;
						  opts.othercolumnsScroll.clickFunc = $(target).attr("onclick");
						  
						  while (target.nodeType != 1) target = target.parentNode;
						  if (target.tagName != 'SELECT' && target.tagName != 'INPUT' && target.tagName != 'TEXTAREA' && target.tagName != 'BUTTON'){
							  if(!$.os.ios){
								  e.preventDefault();
							  }
						  }
					  },
					  onScrollMove :function(event){
						  event.preventDefault();
						  event.stopPropagation();
						  opts.othercolumnsScroll.touchMoveFlag = true;
					  },
					  onTouchEnd : function(){
						  if(opts.othercolumnsScroll.touchMoveFlag){
							  $(opts.othercolumnsScroll.targetElement).removeAttr("onclick");
							  setTimeout(function(){
								  $(opts.othercolumnsScroll.targetElement).attr("onclick",opts.othercolumnsScroll.clickFunc);
								  opts.othercolumnsScroll.targetElement = null;
								  opts.othercolumnsScroll.clickFunc = null;
								  opts.othercolumnsScroll.startY = null;
								  opts.othercolumnsScroll.endY = null;
								  opts.othercolumnsScroll.touchMoveFlag = false;
							  },50);
						  }
					  }
				  });
			}
		}	
	};	
	
	var setCurrentColumn=function(clickColumn){
		sessionStorage["currentColumn"]=clickColumn;
		if(opts.showset=='single-line'){		
			if(opts.columnScroll){
				sessionStorage["columnx"]=opts.columnScroll.x;
			}					
		}		
	};
	
	var setColumnWidth=function(){
		
		$(".js_columngoto").each(function(){
			var w=$(this)[0].offsetWidth;
			opts.ulwidth=opts.ulwidth+w;	
		});
		$('#singleScrollUl').css("width",opts.ulwidth);		
	};
	
	return {
		init : init
	}
}();
